/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.FitDataSet;
import java.io.File;
import java.io.PrintStream;
import java.util.Locale;
import util.Config;
import util.Logger;

public class InlineWriter {
    static Logger logger = Logger.getLogger();
    private FitDataSet mydata;
    private File myOutfile;
    private PrintStream pst;

    public InlineWriter(File of, FitDataSet ps) {
        logger.entry(4, "InlineWriter.InlineWriter");
        this.myOutfile = of;
        this.mydata = ps;
        try {
            this.pst = new PrintStream(this.myOutfile);
        }
        catch (Exception e) {
            logger.log(1, "ERROR : " + e.toString());
        }
        logger.exit(4, "InlineWriter.InlineWriter");
    }

    public void write() {
        Locale loc = Locale.US;
        Config cfg = Config.getConfig();
        for (double f : this.mydata.getFrequencies()) {
            this.pst.print("  // " + cfg.getParam("Antennaname") + "\r\n");
            this.pst.print("  {\r\n");
            this.pst.print("    sAntName=   \"" + cfg.getParam("Antennaname") + "\";\r\n");
            this.pst.print("    eAntCode=   (enumAntCode)" + cfg.getParam("Antennacode") + ";\r\n");
            this.pst.print("    eAntPar=    (enumAntPar)(ANT_PAR_VERT | ANT_PAR_HOR | ANT_PAR_LEFT | ANT_PAR_RIGHT);\r\n");
            String sf = String.valueOf((long)f);
            this.pst.print("    nFreqAzim=  " + sf + "ull;\r\n");
            this.pst.print("\r\n");
            this.pst.print("    static  typCorAzimData  tCorAzimData[]=\r\n");
            this.pst.print("    {\r\n");
            int nodes = this.mydata.getFitData(f).getNodesIn();
            int i = 0;
            while (i < nodes) {
                double val = this.mydata.getFitData(f).getXin(i);
                double corrval = this.mydata.getFitData(f).getCorrectedVal(val);
                double rounded = Math.rint(corrval * 100.0) / 10.0;
                double target = 360.0 / (double)nodes * (double)i;
                this.pst.printf(loc, "      { %-6.0f },   // %6.0f\r\n", rounded, target);
                ++i;
            }
            this.pst.print("    };\r\n");
            this.pst.print("\r\n");
            this.pst.print("    REGISTER_AZIM_DATA();\r\n");
            this.pst.print("  };\r\n");
            this.pst.print("\r\n");
        }
    }
}

